/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nhindirect.gateway.smtp.james.mailet;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.nhindirect.stagent.mail.Message;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.mailet.base.mail.MimeMultipartReport;
import org.nhindirect.stagent.mail.notifications.Disposition;
import org.nhindirect.stagent.mail.notifications.MDNFactory;
import org.nhindirect.stagent.mail.notifications.NotificationType;

/**
 *
 * @author 564685
 */
public class LogMessage {

    private static final Log LOGGER = LogFactory.getFactory().getInstance(
            LogMessage.class);

    public static int logMessageToLog(Mail mail, Connection conn, int log_success,
            int inbound_outbound, int mdn) {
        String sqlQuery;
        if (mdn >= 0) {
            sqlQuery = "INSERT INTO mail_log (time, size, sender, recipient, attachment_types, inbound_outbound, success, mdn, storage_id,  protected_data) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        } else {
            sqlQuery = "INSERT INTO mail_log (time, size, sender, recipient, attachment_types, inbound_outbound, success) VALUES (?, ?, ?, ?, ?, ?, ?)";
        }
        PreparedStatement prepQuery = null;
        int genKey = -1;
        try {
            try {
                prepQuery = conn.prepareStatement(sqlQuery,
                        Statement.RETURN_GENERATED_KEYS);
            } catch (SQLException se) {
                LOGGER.trace("Failed to prepare SQL Server statement when logging to webmail.");
            }
            if (prepQuery != null) {
                // initialize parameters
                MimeMessage message = null;
                Long log_time;
                int log_size;
                String log_sender;
                String log_recipient;
                String log_attachmentTypes;
                String log_inboundOutbound = Integer.toString(inbound_outbound);

                // attempt to get message
                try {
                    message = mail.getMessage();
                } catch (MessagingException me) {
                    LOGGER.debug("Messaging execption while retrieving message for logging to webmail.");
                }
                try {
                    log_time = System.currentTimeMillis() / 1000L; // Timestamp of
                    // sent message
                    if (message != null) {
                        log_size = message.getSize() / 1024;
                    } // Size of the message in KB
                    else {
                        log_size = 0;
                    }
                    log_sender = parseFromAddress(message);
                    log_recipient = parseRecipientsToJSON(message);
                    log_attachmentTypes = parseAttachments(message);
                    try {
                        prepQuery.setString(1, Long.toString(log_time));
                        prepQuery.setString(2, Integer.toString(log_size));
                        prepQuery.setString(3, "" + log_sender);
                        prepQuery.setString(4, log_recipient);
                        prepQuery.setString(5, log_attachmentTypes);
                        prepQuery.setString(6, log_inboundOutbound);
                        prepQuery.setString(7, Integer.toString(log_success));
                        if (mdn >= 0) {
                            prepQuery.setString(8, Integer.toString(mdn));
                            if (inbound_outbound == 0 && mdn == 0 && message != null) {
                                storeMessageID(message);
                                prepQuery.setString(9, message.getHeader("storage-id", null));
                                prepQuery.setString(10, message.getHeader("protected-data", null));                            
                            }
                            else{
                                prepQuery.setString(9, null);
                                prepQuery.setString(10, null); 
                            }
                        }
                        try {
                            prepQuery.executeUpdate();
                            ResultSet rs = null;
                            try {
                                rs = prepQuery.getGeneratedKeys();
                                if (rs.next()) {
                                    genKey = rs.getInt(1);
                                }
                            } finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        } catch (SQLException query_ex) {
                            LOGGER.trace("Failed to log message.");
                        }

                    } catch (SQLException sql_ex) {
                        LOGGER.debug("Failed to prepare SQL statement when logging to webmail.");
                    }
                } catch (MessagingException me) {
                    LOGGER.debug("Messaging execption while retrieving message variables for logging to webmail.");
                }
            }
        } finally {
            if (prepQuery != null) {
                try {
                    prepQuery.close();
                } catch (SQLException ex) {
                    LOGGER.debug("failed to close query");
                }
            }
        }
        return genKey;
    }

    public static String parseFromAddress(MimeMessage message) {
        String from = null;
        try {
            // get from address
            Address[] froms = message.getFrom();

            if (froms != null) {
                String personal = ((InternetAddress) froms[0]).getPersonal();
                String from_address = ((InternetAddress) froms[0]).getAddress();
                if (personal != null) {
                    from = "\"" + personal + "\" <" + from_address + ">";
                } else {
                    from = from_address;
                }
            }
        } catch (MessagingException me) {
            LOGGER.debug("Messaging execption while retrieving sender for logging.");
        }
        return from;
    }

    private static String parseRecipientsToJSON(MimeMessage message) {
        String log_recipient = "";
        // Create JSON array of recipients
        try {
            Address[] recipsAddr = message.getAllRecipients();


            log_recipient = "["; // Pre-bracket
            if (recipsAddr != null) {
                // escape string for JSON
                for (Address addr : recipsAddr) {
                    InternetAddress inet_addr_recip = (InternetAddress) addr;

                    String cur_recip = "";
                    if (inet_addr_recip.getPersonal() != null) {
                        cur_recip += "\"" + inet_addr_recip.getPersonal() + "\" <"
                                + inet_addr_recip.getAddress() + ">";
                    } else {
                        cur_recip += inet_addr_recip.getAddress();
                    }

                    String escaped_recipients = cur_recip.replace("\\", "\\\\")
                            .replace("\"", "\\\"").replace("\r", "\\r")
                            .replace("\n", "\\n");
                    log_recipient += "\"" + escaped_recipients + "\",";
                }
            }

            log_recipient = log_recipient.substring(0,
                    log_recipient.length() - 1);
            log_recipient += "]"; // Post-bracket
        } catch (MessagingException me) {
            LOGGER.debug("Messaging execption while retrieving recipients for logging.");
        }
        return log_recipient;
    }

    public static String parseAttachments(MimeMessage message) {
        String attachmentTypes = "";
        try {
            // Get attachment extensions if message is not plaintext
            if (!message.getContentType().equals("text/plain")) {
                MimeMultipart attachments;
                try {
                    attachments = (MimeMultipart) message.getContent();
                } catch (ClassCastException ce) {
                    attachments = null;
                } catch (IOException ie) {
                    LOGGER.debug("IO Error while post-processing incoming message.");
                    attachments = null;
                } catch (MessagingException me) {
                    LOGGER.debug("Messaging Exception while post-processing incoming message.");
                    attachments = null;
                }

                if (attachments != null) { // parse out attachments if they
                    // exist
                    for (int i = 0; i < attachments.getCount(); i++) {
                        BodyPart part = attachments.getBodyPart(i);
                        if (FilenameUtils.getExtension(part.getFileName()) != null) { // get
                            // file
                            // name
                            // if
                            // its
                            // a
                            // file
                            // attachemnt
                            // part
                            attachmentTypes += FilenameUtils.getExtension(part
                                    .getFileName()) + " ";
                        }
                    }
                    // Remove extra space at end
                    attachmentTypes = attachmentTypes.trim();
                }
            }
        } catch (MessagingException me) {
            LOGGER.debug("Messaging Exception while post-processing incoming message.");
        }
        return attachmentTypes;
    }

    private static void storeMessageID(MimeMessage message) {
        try {
            String message_id = message.getHeader("message-id", null);
            String storage_id = message.getHeader("storage-id", null);
            Map<String, String> properties = MailetProperties.getPropertiesList();
            String db_hostname = properties.get("mailet.db.hostname");
            String db_port = properties.get("mailet.db.port");
            String db_name = properties.get("mailet.db.mailname");
            String db_instance = properties.get("mailet.db.instance");
            String db_userid = properties.get("mailet.db.mailusername");
            String db_password = properties
                    .get("mailet.db.mailpassword");
            Connection conn = null;
            try {
                try {
                    conn = databaseConnect(db_hostname, db_port, db_name,
                            db_instance, db_userid, db_password);
                } catch (SQLException e) {
                    LOGGER.trace("Failed to connect to SQL Server");
                }
                if (conn != null) {
                    String sqlQuery = "update messages set [message_id] = ? where [id] = ?";
                    PreparedStatement prepQuery = null;
                    try {
                        try {

                            prepQuery = conn.prepareStatement(sqlQuery,
                                    Statement.RETURN_GENERATED_KEYS);

                            if (prepQuery != null) {
                                prepQuery.setString(1, message_id);
                                prepQuery.setString(2, storage_id);
                                prepQuery.executeUpdate();
                            }
                        } finally {
                            if (prepQuery != null) {
                                prepQuery.close();
                            }
                        }
                    } catch (SQLException ex) {
                        LOGGER.trace("Failed to connect to SQL Server");
                    }
                }
            } finally {
                if (conn != null) {
                    try {
                        conn.close();
                    } catch (SQLException e) {
                        LOGGER.trace("Failed to close SQL Server");
                    }
                }
            }
            try {
                try {
                    conn = databaseConnect(db_hostname, db_port, db_name,
                            db_instance, db_userid, db_password);
                } catch (SQLException e) {
                    LOGGER.trace("Failed to connect to SQL Server");
                }
                if (conn != null) {
                    String sqlQuery = "update accounting_disclosure set [message_id] = ? where [messages_table_id] = ?";
                    PreparedStatement prepQuery = null;
                    try {
                        try {

                            prepQuery = conn.prepareStatement(sqlQuery,
                                    Statement.RETURN_GENERATED_KEYS);

                            if (prepQuery != null) {
                                prepQuery.setString(1, message_id);
                                prepQuery.setString(2, storage_id);
                                prepQuery.executeUpdate();
                            }
                        } finally {
                            if (prepQuery != null) {
                                prepQuery.close();
                            }
                        }
                    } catch (SQLException ex) {
                        LOGGER.trace("Failed to connect to SQL Server");
                    }
                }
            } finally {
                if (conn != null) {
                    try {
                        conn.close();
                    } catch (SQLException e) {
                        LOGGER.trace("Failed to close SQL Server");
                    }
                }
            }
        } catch (MessagingException ex) {
            LOGGER.debug("Could not get messageID");
        }

    }

    private static Connection databaseConnect(String db_hostname,
            String db_port, String db_name, String db_instance,
            String db_userid, String db_password) throws SQLException {
        Connection conn;
        if (db_hostname == null) {
            return null;
        }
        String db_connect_string = "jdbc:sqlserver://" + db_hostname + ":"
                + db_port + ";databaseName=" + db_name
                + ";ssl=require;hostNameInCertificate=" + db_hostname
                + ";instanceName=" + db_instance + ";portNumber=" + db_port
                + ";trustServerCertificate=true";

        // Load DB Driver
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        } catch (ClassNotFoundException f) {
            LOGGER.trace("Could not load SQL Server DB driver");
        }

        // Connect to DB
        try {
            conn = DriverManager.getConnection(db_connect_string, db_userid,
                    db_password);
        } catch (SQLException sqlException) {
            LOGGER.trace("SQL Server database not reachable");
            return null;
        }

        return conn;
    }

    public static ArrayList<MailAddress> sendExternalNotification(Connection conn, Mail mail) {
        Transport transport = null;
        Map<String, String> properties = MailetProperties.getPropertiesList();
        Properties system_properties = new Properties();
        system_properties.putAll(properties);
        Session session = Session.getInstance(system_properties);
        try {
            transport = session.getTransport();
            transport.connect();
        } catch (MessagingException m) {
            LOGGER.trace("Could not connect to mail server");
        }

        ArrayList<MailAddress> recipients = new ArrayList<MailAddress>(mail.getRecipients());
        // Loop through recipients list
        String ldap_protocol = properties.get("mailet.ldap.protocol");
        String ldap_host = properties.get("mailet.ldap.host");
        String ldap_port = properties.get("mailet.ldap.port");
        String ldap_domain = properties.get("mailet.ldap.domain");
        String ldap_user_dn = properties.get("mailet.ldap.user_dn");
        String ldap_prd = properties.get("mailet.ldap.password");
        String domainsProperty = properties.get("mailet.domain");
        String[] domainsList = domainsProperty.split(",");

       
        AddressCheck addresses = new AddressCheck(recipients, domainsList);
        InitialDirContext ctx = ldapConnect(ldap_host, ldap_port, ldap_protocol, ldap_domain, ldap_user_dn, ldap_prd);
        HashMap<MailAddress, Integer> mailboxes = addresses.getMailbox();
        for (Map.Entry<MailAddress, Integer> mailbox : mailboxes.entrySet()){
        	String username = mailbox.getKey().getLocalPart();
                String domain = mailbox.getKey().getDomain();
        	if(addresses.isGroup(mailbox.getKey())){
        		ArrayList<String> memberList = getGroupMembership(ctx, username);
                ArrayList<String> external_addresses = getGroupExternalAddresses(ctx, conn, ldap_domain, memberList);
                for (int j = 0; j < external_addresses.size(); j++) {
                    String externalMailAddress = external_addresses.get(j);

                    if (externalMailAddress != null && !externalMailAddress.equals("")) {
                        MimeMessage message = createExternalNotification(ctx, mail, username, externalMailAddress, domain, true);
                        try {
                            if (transport != null) {
                                Transport.send(message);
                            } else {
                                LOGGER.info("Failed to send external notification to: " + username);
                            }
                        } catch (MessagingException name_ex) {
                            LOGGER.debug("Exception when sending external notification.");
                        }
                    }
                }
        	}
        	else{
        		String external_address = getExternalAddress(conn, username);
                if (external_address != null && !external_address.equals("")) {
                    MimeMessage message = createExternalNotification(ctx, mail, username, external_address, domain, false);
                    try {
                        if (transport != null) {
                            Transport.send(message);
                        } else {
                            LOGGER.info("Failed to send external notification to: " + username);
                        }
                    } catch (MessagingException name_ex) {
                        LOGGER.debug("Exception when sending external notification.");
                    }
                }
        	}
        }
            
        
        return addresses.getBadAddress();
    }

    public static void proccessMessagesStatus(Mail mail, ArrayList<MailAddress> BadAddress) {
        Map<String, String> properties = MailetProperties.getPropertiesList();
        MailAddress sender = mail.getSender();
        String domainsProperty = properties.get("mailet.domain");
        List<String> domains = Arrays.asList(domainsProperty.split(","));
        boolean isLocal = domains.contains(sender.getDomain());
        String message_id;
        try {
            message_id = mail.getMessage().getHeader("message-id", null);
        } catch (MessagingException ex) {
            LOGGER.debug("Failed to get message id");
            return;
        }
        if (isLocal) {
            long time = mail.getLastUpdated().getTime() / 1000L;
            Collection<MailAddress> recipients = mail.getRecipients();
            Iterator<MailAddress> iterator = recipients.iterator();
            while (iterator.hasNext()) {
                MailAddress recip = iterator.next();
                if (domains.contains(recip.getDomain())) {
                    setMessageStatus(message_id, recip.toString(), 1,time);
                    update_accounting_disclosure( message_id, recip.toString(), time);
                    if (BadAddress.contains(recip)) {
                        setMessageStatus(message_id, recip.toString(), 4,time);
                    }
                } else {
                    setMessageStatus(message_id, recip.toString(), 0, time);
                }
            }
        } else {
            /*String testMessage = "Failed to send";
             if(!BadAddress.isEmpty()){
             for(String address : BadAddress){
             try {
             MimeMessage msg = new MimeMessage(null, new ByteArrayInputStream(testMessage.getBytes("ASCII")));
             msg.setFrom(sender.toInternetAddress());
             msg.setRecipients(javax.mail.Message.RecipientType.TO, address);
             Notification noti = new Notification(NotificationType.Error);
             NotificationMessage notiMsg = NotificationMessage.createNotificationFor(new Message(msg), noti);
             } catch (MessagingException ex) {
             LOGGER.debug("Message Exception for failed mdn");
             } catch (UnsupportedEncodingException ex) {
             LOGGER.debug("Unsuppored Encoding for failed mdn");
             }
             }
             }*/
        }

    }

    

    private static String getExternalAddress(Connection conn, String username) {
        String address = null;
        String sqlQuery = "SELECT user_mail FROM users WHERE user_deleted_flag <> 1 AND user_ext_notify_flag = 1 AND user_name = ?";
        PreparedStatement prepQuery = null;
        try {
            prepQuery = conn.prepareStatement(sqlQuery);
            prepQuery.setString(1, username);
            ResultSet rs = null;
            try {
                rs = prepQuery.executeQuery();
                while (rs.next()) {
                    // Get the email string
                    String externalMailAddress = rs.getString("user_mail");
                    address = externalMailAddress;
                }
            } finally {
                if (rs != null) {
                    rs.close();
                }
            }

        } catch (SQLException sql_ex) {
            LOGGER.debug("Query for group member external email address failed.");
        } finally {
            if (prepQuery != null) {
                try {
                    prepQuery.close();
                } catch (SQLException sql_close_ex) {
                    LOGGER.debug("Failed to close prepared statement for external address lookup query.");
                }
            }
        }
        return address;
    }

    private static ArrayList<String> getGroupExternalAddresses(InitialDirContext ctx, Connection conn, String ldap_domain, ArrayList<String> users) {
        ArrayList<String> addresses = new ArrayList<String>();
        for (int j = 0; j < users.size(); j++) {
            String membername = users.get(j).toString().replace("uid=", "").replace(",ou=accounts," + ldap_domain, "");
            String sqlQuery = "SELECT user_mail,user_is_group FROM users WHERE user_deleted_flag <> 1 AND user_ext_group_notify_flag = 1 AND user_name = ?";

            PreparedStatement prepQuery = null;
            try {
                prepQuery = conn.prepareStatement(sqlQuery);
                prepQuery.setString(1, membername);
                ResultSet rs = null;
                try {
                    rs = prepQuery.executeQuery();
                    while (rs.next()) {
                        // Get the email string
                        String externalMailAddress = rs.getString("user_mail");
                        addresses.add(externalMailAddress);
                    }
                } finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            } catch (SQLException sql_ex) {
                LOGGER.debug("Query for group member external email address failed.");
            } finally {
                if (prepQuery != null) {
                    try {
                        prepQuery.close();
                    } catch (SQLException sql_close_ex) {
                        LOGGER.debug("Failed to close prepared statement for external address lookup query.");
                    }
                }
            }

        }
        return addresses;
    }

    private static ArrayList<String> getGroupMembership(InitialDirContext ctx, String groupname) {
        ArrayList<String> groups = new ArrayList<String>();
        try {
            NamingEnumeration<? extends Attribute> list = null;
            try {

                Attributes group_attrs = ctx.getAttributes("ou=" + groupname + ",ou=groups");
                list = group_attrs.getAll();
            } catch (NamingException name_ex) {
                LOGGER.debug("Naming exception encountered while getting group membership.");
            }

            String group_cn = "";
            //loop through all attributes
            if (list != null) {
                while (list.hasMore()) {
                    String attr = list.next().toString();
                    //check the member attribute
                    if (attr.indexOf("member") == 0) {
                        String[] members = attr.replace("member: ", "").split(", ");
                        groups = new ArrayList<String>(Arrays.asList(members));
                        //remove any member elements that are not valid user accounts
                        for (int j = 0; j < groups.size(); j++) {
                            if (groups.get(j).toString().indexOf("uid=") != 0) {
                                groups.remove(j);
                            }
                        }
                    }
                }
            }
        } catch (NamingException name_ex) {
            LOGGER.debug("Naming exception encountered looking up group members.");
        }
        return groups;
    }

    

    /**
     * Establishes an Initial Directory Context connection with an LDAP
     * directory, specified by parameters
     */
    private static InitialDirContext ldapConnect(String ldap_host, String ldap_port, String ldap_protocol, String ldap_domain, String ldap_user_dn, String ldap_prd) {
        InitialDirContext ctx = null;

        String ldapUrl = ldap_protocol + "://" + ldap_host + ":" + ldap_port + "/" + ldap_domain;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.ldap.LdapCtxFactory");
        ht.put(Context.PROVIDER_URL, ldapUrl);
        ht.put(Context.SECURITY_AUTHENTICATION, "simple");
        ht.put(Context.SECURITY_PRINCIPAL, ldap_user_dn);
        ht.put(Context.SECURITY_CREDENTIALS, ldap_prd);
        try {
            ctx = new InitialDirContext(ht);
        } catch (NamingException name_ex) {
            LOGGER.debug("Naming exception encountered while sending group external notifications.");
            return null;
        }

        return ctx;
    }

    private static MimeMessage createExternalNotification(InitialDirContext ctx, Mail mail, String username, String address, String domain, boolean isGroup) {
        Map<String, String> properties = MailetProperties.getPropertiesList();
        Properties system_properties = new Properties();
        system_properties.putAll(properties);
        Session session = Session.getInstance(system_properties);
        String notificationSender = system_properties.getProperty("mailet.notification.sender");
        String supportEmail = system_properties.getProperty("mailet.supportEmail");
        String senderEmail = mail.getSender().toString();

        MimeMessage message = null;
        //attempt to get message
        try {
            message = mail.getMessage();
        } catch (MessagingException me) {
            LOGGER.debug("Messaging Exception while creating external notifiction message.");
        }
        try {
            if (address != null && username != null) {
                if (!address.equals("") && !username.equals("")) { //only attempt for actual addresses and actual users
                    String to = address;
                    String host = system_properties.getProperty("mail.smtp.host");  // Assuming you are sending email from localhost
                    String product = system_properties.getProperty("productname");
                    system_properties.setProperty("localhost", host); // Setup mail server

                    message = new MimeMessage(session);
                    // Set From: header field of the header.
                    message.setFrom(new InternetAddress(notificationSender));

                    // Set To: header field of the header.
                    message.addRecipient(Message.RecipientType.TO, new InternetAddress(to));

                    // Set Subject: header field
                    if (isGroup) {
                        String group_cn = getGroupCommonName(ctx, username);
                        message.setSubject(group_cn + " has a "+product+" message from: " + senderEmail);
                    } else {
                        message.setSubject("You have a "+product+" message from: " + senderEmail);
                    }

                    // Now set the actual message
                    message.setText("Hello,\r\n\r\nYou have received a new message from ");
                    if (isGroup) {
                        message.setContent("<span style=\"font-family:Verdana\"><h1 style=\"font-size:18px;\">"+product+"</h1><p>Hello,</p><p>Your group has received a new message from [" + senderEmail + "]. Please login to <a href=\"https://" + domain + "\">https://" + domain + "</a> to view the message.</p><p>Thank you,<br/>"+product+" Team<br/><a href=\"mailto:" + supportEmail + "\">" + supportEmail + "</a></p></span>", "text/html");
                    } else {
                        message.setContent("<span style=\"font-family:Verdana\"><h1 style=\"font-size:18px;\">"+product+"</h1><p>Hello,</p><p>You have received a new message from [" + senderEmail + "]. Please login to <a href=\"https://" + domain + "\">https://" + domain + "</a> to view the message.</p><p>Thank you,<br/>"+product+" Team<br/><a href=\"mailto:" + supportEmail + "\">" + supportEmail + "</a></p></span>", "text/html");
                    }
                    message.addHeader("DirectNotification", "localhost");

                    if (isGroup) {
                        LOGGER.info("Sent external notifcation to group member");
                    } else {
                        LOGGER.info("Sent external notifcation to user");
                    }
                }
            }
        } catch (MessagingException mex) {
            LOGGER.debug("Messaging exception encountered while sending group external notifications.");
        }
        return message;
    }

    /**
     * Returns an ArrayList of group member LDAP distinguished names, if given
     * an LDAP connection and group organization unit name to look for
     */
    private static String getGroupCommonName(InitialDirContext ctx, String groupname) {
        String cn = null;
        try {
            NamingEnumeration<? extends Attribute> list = null;
            try {

                Attributes group_attrs = ctx.getAttributes("ou=" + groupname + ",ou=groups");
                list = group_attrs.getAll();
            } catch (NamingException name_ex) {
                LOGGER.debug("Naming exception encountered while getting group name.");
            }

            //loop through all attributes
            if (list != null) {
                while (list.hasMore()) {
                    String attr = list.next().toString();
                    //check the member attribute
                    if (attr.indexOf("cn") == 0) {
                        cn = attr.replace("cn: ", "");
                    }
                }
            }
        } catch (NamingException name_ex) {
            LOGGER.debug("Naming exception encountered looking up group name.");
        }
        return cn;
    }

    public static void setMessageStatus(String message_id, String recipt, int status_code, long time) {

        Map<String, String> properties = MailetProperties.getPropertiesList();
        String db_hostname = properties.get("mailet.db.hostname");
        String db_port = properties.get("mailet.db.port");
        String db_name = properties.get("mailet.db.mailname");
        String db_instance = properties.get("mailet.db.instance");
        String db_userid = properties.get("mailet.db.mailusername");
        String db_password = properties
                .get("mailet.db.mailpassword");
        Connection conn = null;
        try {
            try {
                conn = databaseConnect(db_hostname, db_port, db_name,
                        db_instance, db_userid, db_password);
            } catch (SQLException e) {
                LOGGER.trace("Failed to connect to SQL Server");
            }
            if (conn != null) {
                String sqlQuery = "INSERT INTO message_status ([message_id],[status_code],[recipient],[timestamp]) values (?,?,?,?)";
                PreparedStatement prepQuery = null;
                try {
                    try {

                        prepQuery = conn.prepareStatement(sqlQuery);

                        if (prepQuery != null) {
                            prepQuery.setString(1, message_id);
                            prepQuery.setInt(2, status_code);
                            prepQuery.setString(3, recipt);
                            prepQuery.setLong(4, time);
                            prepQuery.executeUpdate();
                        }
                    } finally {
                        if (prepQuery != null) {
                            prepQuery.close();
                        }
                    }
                } catch (SQLException ex) {
                    LOGGER.trace("Failed to connect to SQL Server");
                }
            }
        } finally {
            if (conn != null) {
                try {
                    conn.close();
                } catch (SQLException e) {
                    LOGGER.trace("Failed to close SQL Server");
                }
            }
        }


    }

   
    public static void update_accounting_disclosure(String message_id, String sender,long time){
        Map<String, String> properties = MailetProperties.getPropertiesList();
        String db_hostname = properties.get("mailet.db.hostname");
        String db_port = properties.get("mailet.db.port");
        String db_name = properties.get("mailet.db.mailname");
        String db_instance = properties.get("mailet.db.instance");
        String db_userid = properties.get("mailet.db.mailusername");
        String db_password = properties
                .get("mailet.db.mailpassword");
        Connection conn = null;
        try {
            try {
                conn = databaseConnect(db_hostname, db_port, db_name,
                        db_instance, db_userid, db_password);
            } catch (SQLException e) {
                LOGGER.trace("Failed to connect to SQL Server");
            }
            if (conn != null) {
                String sqlQuery = "update accounting_disclosure set [received] = ? where [message_id] = ? and recipient = ?";
                PreparedStatement prepQuery = null;
                try {
                    try {
                        if (conn != null) {
                            prepQuery = conn.prepareStatement(sqlQuery);
                        }
                        if (prepQuery != null) {
                            prepQuery.setLong(1, time);
                            prepQuery.setString(2, message_id);
                            prepQuery.setString(3, sender);
                            prepQuery.executeUpdate();
                        }
                    } finally {
                        if (prepQuery != null) {
                            prepQuery.close();
                        }
                    }
                } catch (SQLException ex) {
                    LOGGER.trace("Failed to connect to SQL Server");
                }
            }
        } finally {
            if (conn != null) {
                try {
                    conn.close();
                } catch (SQLException e) {
                    LOGGER.trace("Failed to close SQL Server");
                }
            }
        }
    }
}
